<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BarcodeSearchController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/barcodesearchlist", [PermissionMiddleware::class], "list.barcode_search")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeSearchList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/barcodesearchsearch", [PermissionMiddleware::class], "search.barcode_search")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeSearchSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/barcodesearchquery", [PermissionMiddleware::class], "query.barcode_search")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeSearchSearch", "BarcodeSearchQuery");
    }
}
