<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BarcodeQueryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/barcodequerylist[/{id}]", [PermissionMiddleware::class], "list.barcode_query")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeQueryList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/barcodequeryview[/{id}]", [PermissionMiddleware::class], "view.barcode_query")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeQueryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/barcodequeryedit[/{id}]", [PermissionMiddleware::class], "edit.barcode_query")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeQueryEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/barcodequeryupdate", [PermissionMiddleware::class], "update.barcode_query")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeQueryUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/barcodequerysearch", [PermissionMiddleware::class], "search.barcode_query")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BarcodeQuerySearch");
    }
}
