<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class Barcode2Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/barcode2list[/{id}]", [PermissionMiddleware::class], "list.barcode2")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Barcode2List");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/barcode2view[/{id}]", [PermissionMiddleware::class], "view.barcode2")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Barcode2View");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/barcode2search", [PermissionMiddleware::class], "search.barcode2")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Barcode2Search");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/barcode2query", [PermissionMiddleware::class], "query.barcode2")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Barcode2Search", "Barcode2Query");
    }
}
