<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BannerController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bannerlist[/{id}]", [PermissionMiddleware::class], "list.banner")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BannerList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/banneradd[/{id}]", [PermissionMiddleware::class], "add.banner")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BannerAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bannerview[/{id}]", [PermissionMiddleware::class], "view.banner")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BannerView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/banneredit[/{id}]", [PermissionMiddleware::class], "edit.banner")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BannerEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/bannerdelete[/{id}]", [PermissionMiddleware::class], "delete.banner")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BannerDelete");
    }
}
