<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BankInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bankinfolist[/{id}]", [PermissionMiddleware::class], "list.bank_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bankinfoadd[/{id}]", [PermissionMiddleware::class], "add.bank_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bankinfoview[/{id}]", [PermissionMiddleware::class], "view.bank_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bankinfoedit[/{id}]", [PermissionMiddleware::class], "edit.bank_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/bankinfodelete[/{id}]", [PermissionMiddleware::class], "delete.bank_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankInfoDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/bankinfopreview", [PermissionMiddleware::class], "preview.bank_info")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankInfoPreview", null, false);
    }
}
