<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BankController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/banklist[/{id}]", [PermissionMiddleware::class], "list.bank")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bankadd[/{id}]", [PermissionMiddleware::class], "add.bank")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/bankaddopt", [PermissionMiddleware::class], "addopt.bank")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bankview[/{id}]", [PermissionMiddleware::class], "view.bank")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bankedit[/{id}]", [PermissionMiddleware::class], "edit.bank")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/banksearch", [PermissionMiddleware::class], "search.bank")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BankSearch");
    }
}
