<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BStatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bstatuslist[/{id}]", [PermissionMiddleware::class], "list.b_status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BStatusList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bstatusadd[/{id}]", [PermissionMiddleware::class], "add.b_status")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BStatusAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bstatusview[/{id}]", [PermissionMiddleware::class], "view.b_status")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BStatusView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bstatusedit[/{id}]", [PermissionMiddleware::class], "edit.b_status")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BStatusEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/bstatusdelete[/{id}]", [PermissionMiddleware::class], "delete.b_status")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BStatusDelete");
    }
}
