<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BIncentivePpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bincentivepplist[/{id}]", [PermissionMiddleware::class], "list.b_incentive_pp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentivePpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bincentiveppadd[/{id}]", [PermissionMiddleware::class], "add.b_incentive_pp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentivePpAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bincentiveppedit[/{id}]", [PermissionMiddleware::class], "edit.b_incentive_pp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentivePpEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/bincentiveppdelete[/{id}]", [PermissionMiddleware::class], "delete.b_incentive_pp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentivePpDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bincentiveppsearch", [PermissionMiddleware::class], "search.b_incentive_pp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentivePpSearch");
    }
}
