<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BIncentiveController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bincentivelist[/{id}]", [PermissionMiddleware::class], "list.b_incentive")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentiveList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bincentiveadd[/{id}]", [PermissionMiddleware::class], "add.b_incentive")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentiveAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bincentiveedit[/{id}]", [PermissionMiddleware::class], "edit.b_incentive")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentiveEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/bincentivedelete[/{id}]", [PermissionMiddleware::class], "delete.b_incentive")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentiveDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bincentivesearch", [PermissionMiddleware::class], "search.b_incentive")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BIncentiveSearch");
    }
}
