<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BChargesPlanController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bchargesplanlist[/{id}]", [PermissionMiddleware::class], "list.b_charges_plan")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BChargesPlanList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bchargesplanadd[/{id}]", [PermissionMiddleware::class], "add.b_charges_plan")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BChargesPlanAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/bchargesplanaddopt", [PermissionMiddleware::class], "addopt.b_charges_plan")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BChargesPlanAddopt", null, false);
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bchargesplanedit[/{id}]", [PermissionMiddleware::class], "edit.b_charges_plan")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BChargesPlanEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bchargesplansearch", [PermissionMiddleware::class], "search.b_charges_plan")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BChargesPlanSearch");
    }
}
