<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BAccountTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/baccounttypelist[/{id}]", [PermissionMiddleware::class], "list.b_account_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/baccounttypeadd[/{id}]", [PermissionMiddleware::class], "add.b_account_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/baccounttypeview[/{id}]", [PermissionMiddleware::class], "view.b_account_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/baccounttypeedit[/{id}]", [PermissionMiddleware::class], "edit.b_account_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/baccounttypedelete[/{id}]", [PermissionMiddleware::class], "delete.b_account_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountTypeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/baccounttypesearch", [PermissionMiddleware::class], "search.b_account_type")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountTypeSearch");
    }
}
