<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BAccountIntLogController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/baccountintloglist[/{id}]", [PermissionMiddleware::class], "list.b_account_int_log")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountIntLogList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/baccountintlogadd[/{id}]", [PermissionMiddleware::class], "add.b_account_int_log")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountIntLogAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/baccountintlogview[/{id}]", [PermissionMiddleware::class], "view.b_account_int_log")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountIntLogView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/baccountintlogedit[/{id}]", [PermissionMiddleware::class], "edit.b_account_int_log")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountIntLogEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/baccountintlogdelete[/{id}]", [PermissionMiddleware::class], "delete.b_account_int_log")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountIntLogDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/baccountintlogsearch", [PermissionMiddleware::class], "search.b_account_int_log")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountIntLogSearch");
    }
}
