<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BAccountInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/baccountinfolist[/{id}]", [PermissionMiddleware::class], "list.b_account_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoadd[/{id}]", [PermissionMiddleware::class], "add.b_account_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoview[/{id}]", [PermissionMiddleware::class], "view.b_account_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoedit[/{id}]", [PermissionMiddleware::class], "edit.b_account_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoupdate", [PermissionMiddleware::class], "update.b_account_info")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/baccountinfosearch", [PermissionMiddleware::class], "search.b_account_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoSearch");
    }
}
