<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BAccountInfoAgentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoagentlist[/{id}]", [PermissionMiddleware::class], "list.b_account_info_agent")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoAgentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoagentadd[/{id}]", [PermissionMiddleware::class], "add.b_account_info_agent")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoAgentAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoagentview[/{id}]", [PermissionMiddleware::class], "view.b_account_info_agent")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoAgentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoagentedit[/{id}]", [PermissionMiddleware::class], "edit.b_account_info_agent")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoAgentEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoagentupdate", [PermissionMiddleware::class], "update.b_account_info_agent")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoAgentUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/baccountinfoagentsearch", [PermissionMiddleware::class], "search.b_account_info_agent")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BAccountInfoAgentSearch");
    }
}
