<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AudittrailUController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/audittrailulist[/{id}]", [PermissionMiddleware::class], "list.audittrail_u")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailUList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/audittrailuadd[/{id}]", [PermissionMiddleware::class], "add.audittrail_u")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailUAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/audittrailuview[/{id}]", [PermissionMiddleware::class], "view.audittrail_u")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailUView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/audittrailuedit[/{id}]", [PermissionMiddleware::class], "edit.audittrail_u")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailUEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/audittrailudelete[/{id}]", [PermissionMiddleware::class], "delete.audittrail_u")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailUDelete");
    }
}
