<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AudittrailLController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/audittrailllist[/{id}]", [PermissionMiddleware::class], "list.audittrail_l")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailLList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/audittrailladd[/{id}]", [PermissionMiddleware::class], "add.audittrail_l")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailLAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/audittraillview[/{id}]", [PermissionMiddleware::class], "view.audittrail_l")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailLView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/audittrailledit[/{id}]", [PermissionMiddleware::class], "edit.audittrail_l")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailLEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/audittrailldelete[/{id}]", [PermissionMiddleware::class], "delete.audittrail_l")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailLDelete");
    }
}
