<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AudittrailController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/audittraillist[/{id}]", [PermissionMiddleware::class], "list.audittrail")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/audittrailadd[/{id}]", [PermissionMiddleware::class], "add.audittrail")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/audittrailview[/{id}]", [PermissionMiddleware::class], "view.audittrail")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/audittrailedit[/{id}]", [PermissionMiddleware::class], "edit.audittrail")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/audittraildelete[/{id}]", [PermissionMiddleware::class], "delete.audittrail")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/audittrailsearch", [PermissionMiddleware::class], "search.audittrail")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AudittrailSearch");
    }
}
