<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ApcPfvController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/apcpfvlist[/{id}]", [PermissionMiddleware::class], "list.apc_pfv")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcPfvList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/apcpfvedit[/{id}]", [PermissionMiddleware::class], "edit.apc_pfv")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcPfvEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/apcpfvsearch", [PermissionMiddleware::class], "search.apc_pfv")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcPfvSearch");
    }
}
