<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ApcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/apclist[/{apcid}]", [PermissionMiddleware::class], "list.apc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/apcadd[/{apcid}]", [PermissionMiddleware::class], "add.apc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/apcview[/{apcid}]", [PermissionMiddleware::class], "view.apc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/apcedit[/{apcid}]", [PermissionMiddleware::class], "edit.apc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/apcdelete[/{apcid}]", [PermissionMiddleware::class], "delete.apc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/apcsearch", [PermissionMiddleware::class], "search.apc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ApcSearch");
    }
}
