<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AgentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/agentlist[/{id}]", [PermissionMiddleware::class], "list.agent")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/agentadd[/{id}]", [PermissionMiddleware::class], "add.agent")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/agentaddopt", [PermissionMiddleware::class], "addopt.agent")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/agentview[/{id}]", [PermissionMiddleware::class], "view.agent")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/agentedit[/{id}]", [PermissionMiddleware::class], "edit.agent")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/agentdelete[/{id}]", [PermissionMiddleware::class], "delete.agent")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentDelete");
    }
}
