<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AdminController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/adminlist[/{id}]", [PermissionMiddleware::class], "list.admin")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/adminadd[/{id}]", [PermissionMiddleware::class], "add.admin")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/adminedit[/{id}]", [PermissionMiddleware::class], "edit.admin")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/adminsearch", [PermissionMiddleware::class], "search.admin")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminSearch");
    }
}
