<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AdminCategoryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/admincategorylist[/{id}]", [PermissionMiddleware::class], "list.admin_category")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminCategoryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/admincategoryadd[/{id}]", [PermissionMiddleware::class], "add.admin_category")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminCategoryAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/admincategoryview[/{id}]", [PermissionMiddleware::class], "view.admin_category")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminCategoryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/admincategoryedit[/{id}]", [PermissionMiddleware::class], "edit.admin_category")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminCategoryEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/admincategorydelete[/{id}]", [PermissionMiddleware::class], "delete.admin_category")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AdminCategoryDelete");
    }
}
