<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AddOptionalController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/addoptionallist[/{id}]", [PermissionMiddleware::class], "list.add_optional")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AddOptionalList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/addoptionaladd[/{id}]", [PermissionMiddleware::class], "add.add_optional")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AddOptionalAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/addoptionalview[/{id}]", [PermissionMiddleware::class], "view.add_optional")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AddOptionalView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/addoptionaledit[/{id}]", [PermissionMiddleware::class], "edit.add_optional")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AddOptionalEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/addoptionaldelete[/{id}]", [PermissionMiddleware::class], "delete.add_optional")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AddOptionalDelete");
    }
}
