<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AccountTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/accounttypelist[/{id}]", [PermissionMiddleware::class], "list.account_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/accounttypeadd[/{id}]", [PermissionMiddleware::class], "add.account_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/accounttypeview[/{id}]", [PermissionMiddleware::class], "view.account_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/accounttypeedit[/{id}]", [PermissionMiddleware::class], "edit.account_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/accounttypedelete[/{id}]", [PermissionMiddleware::class], "delete.account_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountTypeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/accounttypesearch", [PermissionMiddleware::class], "search.account_type")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountTypeSearch");
    }
}
