<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AccountInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/accountinfolist[/{id}]", [PermissionMiddleware::class], "list.account_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/accountinfoadd[/{id}]", [PermissionMiddleware::class], "add.account_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/accountinfoview[/{id}]", [PermissionMiddleware::class], "view.account_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/accountinfoedit[/{id}]", [PermissionMiddleware::class], "edit.account_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountInfoEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/accountinfosearch", [PermissionMiddleware::class], "search.account_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountInfoSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/accountinfopreview", [PermissionMiddleware::class], "preview.account_info")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountInfoPreview", null, false);
    }
}
