<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class AccountGrpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/accountgrplist[/{id}]", [PermissionMiddleware::class], "list.account_grp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountGrpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/accountgrpadd[/{id}]", [PermissionMiddleware::class], "add.account_grp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountGrpAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/accountgrpview[/{id}]", [PermissionMiddleware::class], "view.account_grp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountGrpView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/accountgrpedit[/{id}]", [PermissionMiddleware::class], "edit.account_grp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountGrpEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/accountgrpdelete[/{id}]", [PermissionMiddleware::class], "delete.account_grp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountGrpDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/accountgrpsearch", [PermissionMiddleware::class], "search.account_grp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountGrpSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/accountgrppreview", [PermissionMiddleware::class], "preview.account_grp")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AccountGrpPreview", null, false);
    }
}
